/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import cpw.mods.fml.client.FMLClientHandler;
import jds.bibliocraft.BiblioRenderHelper;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BlockItemBookcaseCreative;
import jds.bibliocraft.models.ModelBookcaseBooks;
import jds.bibliocraft.models.ModelBookcaseEmpty;
import jds.bibliocraft.models.OBJBookcase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemBookcaseRenderer
implements IItemRenderer {
    private ModelBookcaseEmpty emptyModel = new ModelBookcaseEmpty();
    private ModelBookcaseBooks booksModel = new ModelBookcaseBooks();
    private OBJBookcase objModel = new OBJBookcase();
    private static boolean useTextureSheet;
    private boolean isCreativeMode;

    public ItemBookcaseRenderer() {
        useTextureSheet = this.usesTextureSheet();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int metaTest = item.func_77960_j();
        String textureLoc = "none";
        NBTTagCompound tags = item.func_77978_p();
        if (tags != null && tags.func_74764_b("renderTexture")) {
            textureLoc = tags.func_74779_i("renderTexture");
        }
        this.isCreativeMode = false;
        if (item.func_77973_b() instanceof BlockItemBookcaseCreative) {
            this.isCreativeMode = true;
        }
        switch (type) {
            case ENTITY: {
                this.renderBookcase(0.3f, -0.02f, 0.0f, metaTest, true, textureLoc, false);
                break;
            }
            case EQUIPPED: {
                this.renderBookcase(0.6f, 0.8f, 0.8f, metaTest, false, textureLoc, false);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderBookcase(0.6f, 0.8f, 0.8f, metaTest, false, textureLoc, false);
                break;
            }
            case INVENTORY: {
                this.renderBookcase(0.8f, 0.65f, 1.0f, metaTest, false, textureLoc, this.isCreativeMode);
                break;
            }
        }
    }

    private void renderBookcase(float i, float j, float k, int metaData, boolean entity, String texLoc, boolean isCreative) {
        float scale = 0.03125f;
        Tessellator tesselator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)i, (float)j, (float)k);
        if (entity) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (useTextureSheet) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getModelTexture(metaData));
            this.emptyModel.renderShelf();
        } else {
            if (texLoc.contentEquals("none")) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getVanillaWoodTexture(metaData));
            } else {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(BiblioRenderHelper.getBlockResource(texLoc));
            }
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.objModel.render();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.BOOKCASE_BOOKS_PNG);
        if (isCreative) {
            this.booksModel.renderBook(1);
            this.booksModel.renderBook(12);
            this.booksModel.renderBook(4);
            this.booksModel.renderBook(5);
            this.booksModel.renderBook(6);
            this.booksModel.renderBook(10);
            this.booksModel.renderBook(11);
            this.booksModel.renderBook(15);
            this.booksModel.renderBook(16);
        } else {
            this.booksModel.renderBooksItem(scale);
        }
        GL11.glPopMatrix();
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.BOOKCASE_EMPTY0_PNG;
            }
            case 1: {
                return CommonProxy.BOOKCASE_EMPTY1_PNG;
            }
            case 2: {
                return CommonProxy.BOOKCASE_EMPTY2_PNG;
            }
            case 3: {
                return CommonProxy.BOOKCASE_EMPTY3_PNG;
            }
            case 4: {
                return CommonProxy.BOOKCASE_EMPTY4_PNG;
            }
            case 5: {
                return CommonProxy.BOOKCASE_EMPTY5_PNG;
            }
        }
        return CommonProxy.BOOKCASE_EMPTY0_PNG;
    }

    public ResourceLocation getVanillaWoodTexture(int meta) {
        switch (meta) {
            case 0: {
                return CommonProxy.PLANKSOAK;
            }
            case 1: {
                return CommonProxy.PLANKSSPRUCE;
            }
            case 2: {
                return CommonProxy.PLANKSBIRCH;
            }
            case 3: {
                return CommonProxy.PLANKSJUNGLE;
            }
            case 4: {
                return CommonProxy.PLANKSACACIA;
            }
            case 5: {
                return CommonProxy.PLANKSOLDOAK;
            }
            case 6: {
                return CommonProxy.FRAME_BLOCK;
            }
        }
        return CommonProxy.PLANKSOAK;
    }

    public boolean usesTextureSheet() {
        return Config.useTextureSheet;
    }
}

